#include <iostream>
#include <unordered_set>
#include <vector>

const int MOD = 998244353;

int main() {
    std::string binarni_niz;
    std::cin >> binarni_niz;

    int duzina = binarni_niz.length();
    std::unordered_set<int> vidjeni;
    std::vector<int> prefiks_xor(duzina + 1, 0);

    for (int i = 0; i < duzina; ++i) {
        prefiks_xor[i + 1] = prefiks_xor[i] ^ (binarni_niz[i] - '0');
    }

    for (int levo = 0; levo < duzina; ++levo) {
        for (int desno = levo; desno < duzina; ++desno) {
            int vrednost_xor = prefiks_xor[desno + 1] ^ prefiks_xor[levo];
            vidjeni.insert(vrednost_xor);
        }
    }

    std::cout << vidjeni.size() % MOD << std::endl;

    return 0;
}